/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.mountainmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIBreakDoor;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EntityWildkin
extends EntityCreatureTameable
implements IMob {
    public EntityWildkin(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 2;
        this.experience = 10;
        this.hasAttackSound = true;
        this.canGrow = true;
        this.babySpawnChance = 0.01;
        this.setWidth = 1.5f;
        this.setHeight = 3.2f;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.func_70661_as() instanceof PathNavigateGround) {
            PathNavigateGround pathNavigateGround = (PathNavigateGround)this.func_70661_as();
            pathNavigateGround.func_179688_b(true);
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("wildkintreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIBreakDoor(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee(this).setRate(20));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 30.0);
        baseAttributes.put("movementSpeed", 0.26);
        baseAttributes.put("knockbackResistance", 0.9);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 6.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151103_aS), 1.0f).setMinAmount(2).setMaxAmount(6));
        this.drops.add(new DropRate(new ItemStack(Items.field_151008_G), 1.0f).setMinAmount(10).setMaxAmount(25));
        this.drops.add(new DropRate(new ItemStack(Items.field_151100_aR, 1, 4), 1.0f).setMinAmount(4).setMaxAmount(8));
    }

    @Override
    public double getFallingMod() {
        return 0.8;
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase && ObjectManager.getPotionEffect("weight") != null) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect((Potion)ObjectManager.getPotionEffect("weight"), this.getEffectDuration(5), 0));
        }
        return true;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76419_f) {
            return false;
        }
        if (ObjectManager.getPotionEffect("weight") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("weight")) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isTamingItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == ObjectManager.getItem("wildkintreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }
}

